#pragma once

/**
 * Operations on a list of fileechos.
 */
class CListOp
{
public:
	/**
	 * Aligns description by spliting it into the lines. All lines except first one
	 * will have not more than LineLength symbols, and description will be started
	 * at prefixLength position in each line.
	 * Last line will not have ending line separator.
	 * @param	desc				description to align
	 * @param	alignedDesc			where to place the result
	 * @param	lineLength			length of each line
	 * @param	lineSeparator		line separator (e.g. CR\0, LF\0, CRLF\0 or something else)
	 * @param	prefixLength		length of empty space in the beginning of each line
	 * @param	firstPrefixLength	assumed length of the beginning of first line (first line will have no prefix), if below zero suppose the usual prefix
	 *								default is -1
	 */
	static void alignDescription(const char* desc,
								 std::string& alignedDesc,
								 int lineLength,
								 const char* lineSeparator,
								 int prefixLength,
								 int firstPrefixLength = -1
								 );
protected:
	CListOp(void) {}	// this is an utility class, we don't need any instances
};
